<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/friends.js");

// Metadata informations of this page
$page_title = "My Friends";
$page_slug	= "friends";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];


// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

// Check if we have a quiz ID parameter
if(isset($_GET["quiz_id"])) {
		
	$quiz_id_filter = $_GET["quiz_id"];

	// Check if there are participants
	$participation_sql = $dbh->prepare("SELECT q.id AS quiz_id, q.title AS quiz_title, q.user_id AS quiz_author, p.id, p.created_at AS participation_date, p.percent, p.nb_good, p.nb_wrong, u.id AS participant_id, u.fullname AS participant_name, u.profile_picture
										FROM quiz q, participation p, user u
										WHERE q.id = p.quiz_id
										AND p.user_id = u.id
										AND q.user_id = :user_id
										AND q.unique_id = :quiz_unique_id
										ORDER BY q.created_at DESC
										");
						
	$participation_sql->bindParam(':user_id', $user_id);
	$participation_sql->bindParam(':quiz_unique_id', $quiz_id_filter);
	$participation_sql->execute();	
	
} 
// If no filter, we get all friends
else {
	
	// Count total quiz for this user
	$user_id = intval($user_id);
	$total_quiz  = $dbh->query("SELECT 
								COUNT(q.id) as rows
								FROM quiz q, participation p, user u
								WHERE q.id = p.quiz_id
								AND p.user_id = u.id
								AND q.user_id = $user_id")->fetch(PDO::FETCH_OBJ);
	
	// Pagination
	$perpage = 5;
	$posts  = $total_quiz->rows;
	$pages  = ceil($posts / $perpage);
	
	$get_pages = isset($_GET['page']) ? $_GET['page'] : 1;
	
	$data = array(
	
		'options' => array(
			'default'   => 1,
			'min_range' => 1,
			'max_range' => $pages
			)
	);
	
	$number = trim($get_pages);
	$number = filter_var($number, FILTER_VALIDATE_INT, $data);
	$range  = $perpage * ($number - 1);
	
	$prev = $number - 1;
	$next = $number + 1;
	
	
	// Check if there are participants
	$participation_sql = $dbh->prepare("SELECT q.id AS quiz_id, q.title AS quiz_title, q.user_id AS quiz_author, p.id, p.created_at AS participation_date, p.percent, p.nb_good, p.nb_wrong, u.id AS participant_id, u.fullname AS participant_name, u.profile_picture
										FROM quiz q, participation p, user u
										WHERE q.id = p.quiz_id
										AND p.user_id = u.id
										AND q.user_id = :user_id
										ORDER BY q.created_at DESC LIMIT :limit, :perpage
										");
						
	$participation_sql->bindParam(':user_id', $user_id);
	$participation_sql->bindParam(':perpage', $perpage, PDO::PARAM_INT);
	$participation_sql->bindParam(':limit', $range, PDO::PARAM_INT);
	$participation_sql->execute();	
	
}



// -- Include the header template
include("templates/headers/global_header.php")
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>

<div class="row">
	
	<div class="inner-container">
		<center>
			<a class="btn btn-primary btn-create-quiz" href="create-quiz.php"><i class="em em-computer"></i> Create a Quiz</a>
			<?php
			if($_SESSION["RANK"] == 1) {	
			?>
			<a class="btn btn-danger btn-admin-area" href="admin.php"><i class="em em-closed_lock_with_key"></i> Admin Area</a>
			<?php
			}
			?>		
		</center>
		<br />	
		<div class="quiz_list_container">
			<?php
			if($participation_sql->rowCount() == 0) {
			?>
			<div class="alert alert-danger alert-center">
				You have no friends for the moment <i class="em em-anguished"></i>
				<br />
				Create a quiz and share it on <b>Facebook</b> so you will see your friends appearing here !
			</div>
			<?php
			} else {
			?>
			<table class="table table-striped table-quizzes">
				<tr>
					<th>Photo</th>
					<th>Friend</th>
					<th>Results</th>
				</tr>
				<?php
				while($friend = $participation_sql->fetch(PDO::FETCH_ASSOC)) {
				?>
				<tr class="quiz-line">
					<?php
					if($friend["profile_picture"] == "") {	
					?>
					<td><div class="friend_profile_pic"><img src="img/default_avatar.jpg" /></div></td>
					<?php
					} else {
					?>
					<td><div class="friend_profile_pic"><img src="<?php echo $friend["profile_picture"]; ?>" /></div></td>
					<?php
					}	
					?>				
					<td class="align-left">
						<?php echo htmlspecialchars($friend["participant_name"]); ?><br>
						<small><?php echo htmlspecialchars($friend["quiz_title"]); ?></small>
					</td>
					<td>
						<?php echo $friend["percent"]; ?>%<br><small><?php echo $friend["nb_good"]; ?>/<?php echo ($friend["nb_good"]+$friend["nb_wrong"]); ?></small>
					</td>
				</tr>
				<?php
				}	
				?>
			</table>
			<?php
			if(isset($posts) && $posts > 0) {
				if($pages > 1) {	
				?>
				<div class="pagination">
				<?php	
					echo "<div class='page-list'>";
	
					# first page
					if($number <= 1)
						echo "<span>&laquo; prev</span> | <a href=\"?page=$next\">next &raquo;</a>";
					
					# last page
					else if($number >= $pages)
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <span>next &raquo;</span>";
					
					# in range
					else
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <a href=\"?page=$next\">next &raquo;</a>";
	
					echo "</div>";
				?>
				</div>
				<?php
				}
			}	
			?>
			<?php
			}
			?>
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>